CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE upper(TABLE_NAME) = 'EST_TRIB_IBS_CBS') THEN 
        CREATE TABLE EST_TRIB_IBS_CBS
			(
				CD_TRIB_IBS_CBS          integer                NOT NULL,
				DS_TRIB_IBS_CBS          varchar(150)           NOT NULL,
				CST_IBS_CBS              varchar(3),
				CLASS_TRIB_IBS_CBS       varchar(6),
				PERC_IBS_UF              numeric(18,2),
				PERC_IBS_UF_DIFERIMENTO  numeric(18,2),
				PERC_IBS_UF_RED          numeric(18,2),
				PERC_IBS_UF_RED_EFET     numeric(18,2),
				PERC_IBS_MUN             numeric(18,2),
				PERC_IBS_MUN_DIFERIMENTO numeric(18,2),
				PERC_IBS_MUN_RED         numeric(18,2),
				PERC_IBS_MUN_RED_EFET    numeric(18,2),
				PERC_CBS                 numeric(18,2),
				PERC_CBS_DIFERIMENTO     numeric(18,2),
				PERC_CBS_RED             numeric(18,2),
				PERC_CBS_RED_EFET        numeric(18,2),
				DT_CAD                   timestamp without time zone DEFAULT now(),
				CD_USU                   integer,
				DT_ULT_ALT               timestamp without time zone,
				CD_USU_ALT               integer,
				
				CONSTRAINT PK_EST_TRIB_IBS_CBS PRIMARY KEY (CD_TRIB_IBS_CBS)
			)
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA EST_TRIB_IBS_CBS %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();

